[//lasso
	define_tag(
		'stricthtml',
		-namespace='encode_',
		-required='in',
		-priority='replace',
		-description='Encodes all characters in the given string to their HTML equivalents.'
	);
		local('out' = string);
		
		iterate(#in, local('i'));
			#out += '&#' + #i->integer(1) + ';';
		/iterate;
		
		return(@#out);
	/define_tag;
	

	define_tag(
		'urlpath',
		-namespace='encode_',
		-required='in',
		-priority='replace',
		-description='Makes a string safe to use as a URL path component with Apache.'
	);		
		local('out') = #in;		
		#out->replace(' ','_')&replace('/','-!')&replace('\'','`');
		#out = encode_stricturl(#out);
		#out->replace('%5c','&#92;');
		return(@#out);
	/define_tag;


	define_tag(
		'urlpath',
		-namespace='decode_',
		-required='in',
		-priority='replace',
		-description='Decodes a string encoded by [encode_urlpath].'
	);
		local('out') = #in;
		#out->replace('_',' ')&replace('&#92;','%5c');
		#out = decode_url(#out);
		#out->replace('-!','/')&replace('`','\'');
		return(@#out);
	/define_tag;
]
