Drupal.locale = { 'pluralFormula': function ($n) { return Number(($n>1)); }, 'strings': {"":{"An AJAX HTTP error occurred.":"Une erreur HTTP AJAX s\u0027est produite.","HTTP Result Code: !status":"Code de statut HTTP : !status","An AJAX HTTP request terminated abnormally.":"Une requ\u00eate HTTP AJAX s\u0027est termin\u00e9e anormalement.","Debugging information follows.":"Informations de d\u00e9bogage ci-dessous.","Path: !uri":"Chemin : !uri","StatusText: !statusText":"StatusText: !statusText","ResponseText: !responseText":"ResponseText : !responseText","ReadyState: !readyState":"ReadyState : !readyState","(active tab)":"(onglet actif)","Hide":"Masquer","Show":"Afficher","Configure":"Configurer","Re-order rows by numerical weight instead of dragging.":"R\u00e9-ordonner les lignes avec des poids num\u00e9riques plut\u00f4t qu\u0027en les d\u00e9pla\u00e7ant.","Show row weights":"Afficher le poids des lignes","Hide row weights":"Cacher le poids des lignes","Drag to re-order":"Cliquer-d\u00e9poser pour r\u00e9-organiser","Changes made in this table will not be saved until the form is submitted.":"Les changements effectu\u00e9s dans ce tableau ne seront pris en compte que lorsque la configuration aura \u00e9t\u00e9 enregistr\u00e9e.","Content can only be inserted into CKEditor in the WYSIWYG mode.":"Le contenu peut seulement \u00eatre ins\u00e9r\u00e9 dans CKEditor en mode WYSIWYG.","Next":"Suivant","Edit":"Modifier","Sunday":"Dimanche","Monday":"Lundi","Tuesday":"Mardi","Wednesday":"Mercredi","Thursday":"Jeudi","Friday":"Vendredi","Saturday":"Samedi","Add":"Ajouter","All":"Tout","Done":"Termin\u00e9","OK":"OK","This field is required.":"Ce champ est requis.","Prev":"Pr\u00e9c.","Mon":"lun","Tue":"mar","Wed":"mer","Thu":"jeu","Fri":"ven","Sat":"sam","Sun":"dim","January":"janvier","February":"F\u00e9vrier","March":"mars","April":"avril","May":"mai","June":"juin","July":"juillet","August":"ao\u00fbt","September":"septembre","October":"octobre","November":"novembre","December":"d\u00e9cembre","Select all rows in this table":"S\u00e9lectionner toutes les lignes du tableau","Deselect all rows in this table":"D\u00e9s\u00e9lectionner toutes les lignes du tableau","Today":"Aujourd\u0027hui","Jan":"Jan","Feb":"f\u00e9v","Mar":"mar","Apr":"avr","Jun":"juin","Jul":"juil","Aug":"ao\u00fb","Sep":"sep","Oct":"oct","Nov":"nov","Dec":"d\u00e9c","Su":"Di","Mo":"Lu","Tu":"Ma","We":"Me","Th":"Je","Fr":"Ve","Sa":"Sa","Not published":"Non publi\u00e9","Please wait...":"Veuillez patienter...","mm\/dd\/yy":"dd\/mm\/yy","By @name on @date":"Par @name le @date","By @name":"Par @name","Not in menu":"Pas dans le menu","Alias: @alias":"Alias : @alias","No alias":"Aucun alias","New revision":"Nouvelle r\u00e9vision","The changes to these blocks will not be saved until the \u003Cem\u003ESave blocks\u003C\/em\u003E button is clicked.":"N\u0027oubliez pas de cliquer sur \u003Cem\u003EEnregistrer les blocs\u003C\/em\u003E pour confirmer les modifications apport\u00e9es ici.","No revision":"Aucune r\u00e9vision","Requires a title":"Titre obligatoire","Not restricted":"Non restreint","Not customizable":"Non personnalisable","Restricted to certain pages":"R\u00e9serv\u00e9 \u00e0 certaines pages","The block cannot be placed in this region.":"Le bloc ne peut pas \u00eatre plac\u00e9 dans cette r\u00e9gion.","Hide summary":"Masquer le r\u00e9sum\u00e9","Edit summary":"Modifier le r\u00e9sum\u00e9","Don\u0027t display post information":"Ne pas afficher les informations de la contribution","The selected file %filename cannot be uploaded. Only files with the following extensions are allowed: %extensions.":"Le fichier s\u00e9lectionn\u00e9 %filename ne peut pas \u00eatre transf\u00e9r\u00e9. Seulement les fichiers avec les extensions suivantes sont permis : %extensions.","Autocomplete popup":"Popup d\u0027auto-compl\u00e9tion","Searching for matches...":"Recherche de correspondances...","New":"Nouveau","Remove group":"Supprimer le groupe","Apply (all displays)":"Appliquer (tous les affichages)","Apply (this display)":"Appliquer (cet affichage)","Revert to default":"R\u00e9tablir par d\u00e9faut","Loading token browser...":"Chargement de l\u0027explorateur de jetons...","Available tokens":"Jetons (tokens) disponibles","Insert this token into your form":"Ins\u00e9rer ce jeton (\u003Cem\u003Etoken\u003C\/em\u003E) dans votre formulaire","First click a text field to insert your tokens into.":"Cliquez d\u0027abord sur un champ de texte pour ins\u00e9rer vos jetons (\u003Cem\u003Etokens\u003C\/em\u003E) dans celui -ci.","Automatic alias":"Alias automatique","No results":"Aucun r\u00e9sultat","Open file browser":"Ouvrir le navigateur de fichiers","Inclusion: @value":"Inclusion : @value","Priority: @value":"Priorit\u00e9 : @value","@label: @value":"@label: @value","Using defaults":"Utiliser les param\u00e8tres par d\u00e9faut.","Scheduled for publishing":"Planifi\u00e9 pour publication","Scheduled for unpublishing":"Planifi\u00e9 pour d\u00e9publication","Not scheduled":"Non planifi\u00e9","Publishing enabled":"Publication activ\u00e9e","Unpublishing enabled":"D\u00e9publication activ\u00e9e","Recent":"R\u00e9cent","Ignored from settings":"Ignor\u00e9 volontairement"}} };;
/**
 * JavaScript functions for front-end display of webform conditional components
 */
(function ($) {
	
Drupal.behaviors.webform_conditional = Drupal.behaviors.webform_conditional || {};
Drupal.behaviors.webform_conditional.attach = function() {
	// create quasi static var to save perfomance
	Drupal.webform_conditional.wrappers = new Object();
	Drupal.webform_conditional.components = new Object();
  $.each(Drupal.settings, function(key, info) {
    if(key.substring(0, 20) == 'webform_conditional_') {
      $.each(info.fields, function(triggerField_key, triggerField_info) {
        
        var formItemWrapper = Drupal.webform_conditional.getWrapper(triggerField_info);
        if(formItemWrapper.length > 0){
            // Add onclick handler to Parent field
            Drupal.webform_conditional.addOnChange (triggerField_key, triggerField_info, key);
        }
        });
      // after all added - trigger initial
  
      $.each(info.fields, function(triggerField_key, triggerField_info) {
        var formItemWrapper = Drupal.webform_conditional.getWrapper(triggerField_info);
          if(formItemWrapper.length > 0){
            var field_name = Drupal.webform_conditional.escapeId(triggerField_key);
            var components = Drupal.webform_conditional.getComponentsByName(field_name, key);
            if(components.attr('type')=='radio' || components.attr('type')=='checkbox'){
              $(components[0]).triggerHandler('click');
            }else{
              components.triggerHandler('change');
            }
          }
        });
      }
    });
	return;
};
Drupal.webform_conditional = Drupal.webform_conditional || {};
// create quasi static var to save perfomance
Drupal.webform_conditional.getWrapper = function(fieldInfo){
	if(Drupal.webform_conditional.wrappers[fieldInfo['css_id']]){
		return Drupal.webform_conditional.wrappers[fieldInfo['css_id']];
	}
	return Drupal.webform_conditional.wrappers[fieldInfo['css_id']] = $("#" + fieldInfo['css_id']);
};
Drupal.webform_conditional.addOnChange = function(triggerField_key, triggerField_info, key) {
	var monitor_field_name = Drupal.webform_conditional.escapeId(triggerField_key);
	var changeFunction = function() {
		Drupal.webform_conditional.setVisibility(triggerField_key,triggerField_info,key);
	};
	$.each(triggerField_info['dependent_fields'],function(dependent_field_key,dependent_field_info){
		var formItemWrapper = Drupal.webform_conditional.getWrapper(dependent_field_info);
	    if(formItemWrapper.length > 0){
	            formItemWrapper.css("display", "none");
	    }

	});
	var components = Drupal.webform_conditional.getComponentsByName(monitor_field_name, key);
	if(components.attr('type')=='radio' || components.attr('type')=='checkbox'){
		components.click(changeFunction)
	}else{
		components.change(changeFunction);
	}
	
};
Drupal.webform_conditional.setVisibility = function(triggerField_key,triggerField_info,key,monitorField,monitorInfo){
	var monitor_field_name = Drupal.webform_conditional.escapeId(triggerField_key);
	var currentValues = Drupal.webform_conditional.getFieldValue(monitor_field_name); 
	var monitor_visible = true;
	if(monitorField !== undefined){
		monitor_visible = Drupal.webform_conditional.getWrapper(monitorInfo).data('wfc_visible');
	}
	$.each(triggerField_info['dependent_fields'],function(dependentField,dependentInfo){
		if(((dependentInfo['operator'] == "=" && !Drupal.webform_conditional.Matches(currentValues,dependentInfo['monitor_field_value']))
			|| (dependentInfo['operator'] == "!=" && Drupal.webform_conditional.Matches(currentValues,dependentInfo['monitor_field_value']))) 
			|| !monitor_visible){
				// show the hidden div
				// have to set wfc_visible so that you check the visibility of this
				// immediately
			 Drupal.webform_conditional.getWrapper(dependentInfo).hide().data('wfc_visible',false);
		}else {
				// otherwise, hide it
			Drupal.webform_conditional.getWrapper(dependentInfo).show().data('wfc_visible',true);
				// and clear data (using different selector: want the
				// textarea to be selected, not the parent div)
		}
		Drupal.webform_conditional.TriggerDependents(dependentField,dependentInfo,key);
	});
};
Drupal.webform_conditional.getComponentsByName = function (field_name, key){
	// check to save jquery calls
	if(Drupal.webform_conditional.components[field_name]){
		return Drupal.webform_conditional.components[field_name];
	}
	// don't overwrite original name to store for caching
	var css_field_name = "[" + field_name + "]";
	settings = Drupal.settings[key];
	var nid = settings.nid;
	if(nid instanceof Array){
		nid = settings.nid[0];
	}
	return Drupal.webform_conditional.components[field_name] = $("#webform-client-form-" + nid + " *[name*='"+css_field_name+"']");
};
Drupal.webform_conditional.TriggerDependents = function(monitorField,monitorInfo, key){
  settings = Drupal.settings[key];
	$.each(settings.fields, function(triggerField_key, triggerField_info) {
		if(triggerField_key == monitorField){
			Drupal.webform_conditional.setVisibility(triggerField_key, triggerField_info,key,monitorField,monitorInfo);
		};
	});
};
Drupal.webform_conditional.getFieldValue = function(field_name){
	field_name = "[" + field_name + "]";
	var selected = [];
	var vals = [];
	if($('form input[name*="'+field_name+'"]:checked').length >= 1){
		selected =  $('form input[name*="'+field_name+'"]:checked');
	}else if($('form select[name*="'+field_name+'"] option:selected').length >= 1){
		selected = $('form select[name*="'+field_name+'"] option:selected');
	}
	if(selected.length == 0){
		return vals;
	}
	selected.each(function(i){
	     vals[i] = $(this).val();
	    });
	return vals;
};
Drupal.webform_conditional.Matches = function(currentValues,triggerValues){
	var found = false;
	$.each(triggerValues, function(index, value) { 
		  if(jQuery.inArray(value,currentValues)> -1){
			  found = true;
			  return false;
		  }
		});
	return found;
};
// Drupal.webform_conditional.escapeId
Drupal.webform_conditional.escapeId = function(myid) {
	if (typeof myid == 'undefined') {
		return;
	}
	   return  myid.replace(/(:|\.)/g,'\\$1');
};
})(jQuery);;
