<?php
/**
 * 2007-2014 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2014 PrestaShop SA
 *  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

/**

 * Implements an XML element <ack>, child of response to Remote Control WS : <answer>

 *

 * @author ESPIAU Nicolas

 */
class KwixoRemoteControlResponseAck extends KwixoDOMDocument
{
	public function getTransactionID()
	{
		return $this->root->getAttribute('transactionid');
	}

	public function getChecksum()
	{
		return $this->root->getAttribute('checksum');
	}

	public function getValue()
	{
		return $this->root->nodeValue;
	}

	/**

	 * returns true if the call failed, false otherwise

	 *

	 * @return bool

	 */
	public function hasError()
	{
		return $this->root->hasAttribute('liberr');
	}

	/**

	 * returns the error code

	 *

	 * @return string

	 */
	public function getErrorCode()
	{
		return $this->root->getAttribute('coderr');
	}

	/**

	 * returns the error label

	 *

	 * @return string

	 */
	public function getError()
	{
		return $this->root->getAttribute('liberr');
	}

	/**

	 * generates and returns a checksum

	 * 

	 * @return string

	 */
	public function generateChecksum()
	{
		$md5 = new KwixoMD5();
		$kwixo = new Kwixo();
		$checksum = $md5->hash($kwixo->getAuthkey().(string)$this->getTransactionID().$this->root->nodeValue);
		return $checksum;
	}

	/**

	 * returns true if the received checksum is valid, false otherwise

	 *

	 * @return bool

	 */
	public function checksumIsValid()
	{
		//gets the received checksum
		$checksum = $this->getChecksum();
		//generates the waited checksum
		$waitedchecksum = $this->generateChecksum();
		//returns true if checksums match, false otherwise
		return $checksum == $waitedchecksum;
	}
}