<?php
/*
 * @author Comevents (Adrien)
 * 
 * @info surcharge 1: Ajout d'actions permettant de proposé un produit de remplacement
 *                  -> voir les fonction haveThisAccessory, haveThisSimilar, initFormAssociations, processAdd, 
 *                  processDuplicate, processUpdate, updateAccessories, updateSimilar
 * @info surcharge 2: Ajout d'une colonne et d'un filtre par promotion dans la page Catalogue->Produits
 * 
 */
class AdminProductsController  extends AdminProductsControllerCore
{
	public function __construct()
	{
    parent::__construct();
    
    // Ajout de la colonne permettant de filtrer les produits étant en vente flash
    $this->_join .= ' LEFT JOIN `'._DB_PREFIX_.'specific_price` sp ON (sp.`id_product` = a.`id_product`) ';
    
    $this->_select .= ' ,CASE WHEN `reduction` > 0 THEN IF(a.vente_flash=0, 1, 0) ELSE 0 END AS `id_specific_price1`';
    $this->fields_list['id_specific_price1'] = array(
			'title' => $this->l('Promotion'),     // Label dans le header du tableau
			'active' => 'id_specific_price1',                // Mise en forme du résultat (vert ou rouge)
			'filter_key' => 'id_specific_price1',          // Résultat correspondant au select
			'align' => 'text-center',
			'type' => 'bool',                     // Affiche une liste déroulante permettant de filtrer sur oui/non
			'class' => 'fixed-width-sm kill-link',
			'orderby' => true,                    // Active les tries montant et descendant
      'search' => false                     // Désactive la recherche
		);
    
    
    // Pour identifier une vente flash: la promotion "vente_flash"=0 et la fin de la date du prix spécifique>aujourd'hui 
    $this->_select .= ' ,CASE WHEN `to` > NOW() THEN IF(a.vente_flash=1, 1, 0) ELSE 0 END AS `id_specific_price`';
    
    $this->fields_list['id_specific_price'] = array(
			'title' => $this->l('Vente Flash'),
      'active' => 'id_specific_price',
			'filter_key' => 'id_specific_price',
			'align' => 'text-center',
			'type' => 'bool',
			'class' => 'fixed-width-sm kill-link',
			'orderby' => true,
      'search' => false
		);
    
    // echo '<pre>';print_r($this->fields_list);echo '</pre>';die('fin');
	}
  
  /**
   * Permet de prendre en compte la case à cocher vente_flash dans le back office
   */
  protected function copyFromPost(&$object, $table)
  {
    parent::copyFromPost($object, $table);
    $object->vente_flash = (int)Tools::getValue('vente_flash');
  }

	public function processDuplicate()
	{
		if (Validate::isLoadedObject($product = new Product((int)Tools::getValue('id_product'))))
		{
			$id_product_old = $product->id;
			if (empty($product->price) && Shop::getContext() == Shop::CONTEXT_GROUP)
			{
				$shops = ShopGroup::getShopsFromGroup(Shop::getContextShopGroupID());
				foreach ($shops as $shop)
					if ($product->isAssociatedToShop($shop['id_shop']))
					{
						$product_price = new Product($id_product_old, false, null, $shop['id_shop']);
						$product->price = $product_price->price;
					}
			}
			unset($product->id);
			unset($product->id_product);
			$product->indexed = 0;
			$product->active = 0;
			if ($product->add()
			&& Category::duplicateProductCategories($id_product_old, $product->id)
			&& ($combination_images = Product::duplicateAttributes($id_product_old, $product->id)) !== false
			&& GroupReduction::duplicateReduction($id_product_old, $product->id)
			&& Product::duplicateAccessories($id_product_old, $product->id)
			&& Product::duplicateSimilars($id_product_old, $product->id)
			&& Product::duplicateSubstitutions($id_product_old, $product->id)
			&& Product::duplicateFeatures($id_product_old, $product->id)
			&& Product::duplicateSpecificPrices($id_product_old, $product->id)
			&& Pack::duplicate($id_product_old, $product->id)
			&& Product::duplicateCustomizationFields($id_product_old, $product->id)
			&& Product::duplicateTags($id_product_old, $product->id)
			&& Product::duplicateDownload($id_product_old, $product->id))
			{
				if ($product->hasAttributes())
					Product::updateDefaultAttribute($product->id);

				if (!Tools::getValue('noimage') && !Image::duplicateProductImages($id_product_old, $product->id, $combination_images))
					$this->errors[] = Tools::displayError('An error occurred while copying images.');
				else
				{
					Hook::exec('actionProductAdd', array('product' => $product));
					if (in_array($product->visibility, array('both', 'search')) && Configuration::get('PS_SEARCH_INDEXATION'))
						Search::indexation(false, $product->id);
					$this->redirect_after = self::$currentIndex.(Tools::getIsset('id_category') ? '&id_category='.(int)Tools::getValue('id_category') : '').'&conf=19&token='.$this->token;
				}
			}
			else
				$this->errors[] = Tools::displayError('An error occurred while creating an object.');
		}
	}
	
	public function processAdd()
	{
		$this->checkProduct();

		if (!empty($this->errors))
		{
			$this->display = 'add';
			return false;
		}

		$this->object = new $this->className();
		$this->_removeTaxFromEcotax();
		$this->copyFromPost($this->object, $this->table);

		if ($this->object->add())
		{
			PrestaShopLogger::addLog(sprintf($this->l('%s addition', 'AdminTab', false, false), $this->className), 1, null, $this->className, (int)$this->object->id, true, (int)$this->context->employee->id);
			$this->addCarriers($this->object);
			$this->updateAccessories($this->object);
			$this->updateSimilars($this->object);
			$this->updateSubstitutions($this->object);
			$this->updatePackItems($this->object);
			$this->updateDownloadProduct($this->object);

			if (Configuration::get('PS_FORCE_ASM_NEW_PRODUCT') && Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT'))
			{
				$this->object->advanced_stock_management = 1;
				StockAvailable::setProductDependsOnStock($this->object->id, true, (int)$this->context->shop->id, 0);
				$this->object->save();
			}

			if (empty($this->errors))
			{
				$languages = Language::getLanguages(false);
				if ($this->isProductFieldUpdated('category_box') && !$this->object->updateCategories(Tools::getValue('categoryBox')))
					$this->errors[] = Tools::displayError('An error occurred while linking the object.').' <b>'.$this->table.'</b> '.Tools::displayError('To categories');
				elseif (!$this->updateTags($languages, $this->object))
					$this->errors[] = Tools::displayError('An error occurred while adding tags.');
				else
				{
					Hook::exec('actionProductAdd', array('product' => $this->object));
					if (in_array($this->object->visibility, array('both', 'search')) && Configuration::get('PS_SEARCH_INDEXATION'))
						Search::indexation(false, $this->object->id);
				}

				if (Configuration::get('PS_DEFAULT_WAREHOUSE_NEW_PRODUCT') != 0 && Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT'))
				{
					$warehouse_location_entity = new WarehouseProductLocation();
					$warehouse_location_entity->id_product = $this->object->id;
					$warehouse_location_entity->id_product_attribute = 0;
					$warehouse_location_entity->id_warehouse = Configuration::get('PS_DEFAULT_WAREHOUSE_NEW_PRODUCT');
					$warehouse_location_entity->location = pSQL('');
					$warehouse_location_entity->save();
				}

				// Save and preview
				if (Tools::isSubmit('submitAddProductAndPreview'))
					$this->redirect_after = $this->getPreviewUrl($this->object);

				// Save and stay on same form
				if ($this->display == 'edit')
					$this->redirect_after = self::$currentIndex.'&id_product='.(int)$this->object->id
						.(Tools::getIsset('id_category') ? '&id_category='.(int)Tools::getValue('id_category') : '')
						.'&updateproduct&conf=3&key_tab='.Tools::safeOutput(Tools::getValue('key_tab')).'&token='.$this->token;
				else
					// Default behavior (save and back)
					$this->redirect_after = self::$currentIndex
						.(Tools::getIsset('id_category') ? '&id_category='.(int)Tools::getValue('id_category') : '')
						.'&conf=3&token='.$this->token;
			}
			else
			{
				$this->object->delete();
				// if errors : stay on edit page
				$this->display = 'edit';
			}
		}
		else
			$this->errors[] = Tools::displayError('An error occurred while creating an object.').' <b>'.$this->table.'</b>';
			
		return $this->object;
	}
	
	public function processUpdate()
	{
		$existing_product = $this->object;

		$this->checkProduct();

		if (!empty($this->errors))
		{
			$this->display = 'edit';
			return false;
		}

		$id = (int)Tools::getValue('id_'.$this->table);
		/* Update an existing product */
		if (isset($id) && !empty($id))
		{
			$object = new $this->className((int)$id);
			$this->object = $object;

			if (Validate::isLoadedObject($object))
			{
				$this->_removeTaxFromEcotax();
				$product_type_before = $object->getType();
				$this->copyFromPost($object, $this->table);
				$object->indexed = 0;

				if (Shop::isFeatureActive() && Shop::getContext() != Shop::CONTEXT_SHOP)
					$object->setFieldsToUpdate((array)Tools::getValue('multishop_check'));

				// Duplicate combinations if not associated to shop
				if ($this->context->shop->getContext() == Shop::CONTEXT_SHOP && !$object->isAssociatedToShop())
				{
					$is_associated_to_shop = false;
					$combinations = Product::getProductAttributesIds($object->id);
					if ($combinations)
					{
						foreach ($combinations as $id_combination)
						{
							$combination = new Combination((int)$id_combination['id_product_attribute']);
							$default_combination = new Combination((int)$id_combination['id_product_attribute'], null, (int)$this->object->id_shop_default);

							$def = ObjectModel::getDefinition($default_combination);
							foreach ($def['fields'] as $field_name => $row)
								$combination->$field_name = ObjectModel::formatValue($default_combination->$field_name, $def['fields'][$field_name]['type']);

							$combination->save();
						}
					}
				}
				else
					$is_associated_to_shop = true;

				if ($object->update())
				{
					// If the product doesn't exist in the current shop but exists in another shop
					if (Shop::getContext() == Shop::CONTEXT_SHOP && !$existing_product->isAssociatedToShop($this->context->shop->id))
					{
						$out_of_stock = StockAvailable::outOfStock($existing_product->id, $existing_product->id_shop_default);
						$depends_on_stock = StockAvailable::dependsOnStock($existing_product->id, $existing_product->id_shop_default);
						StockAvailable::setProductOutOfStock((int)$this->object->id, $out_of_stock, $this->context->shop->id);
						StockAvailable::setProductDependsOnStock((int)$this->object->id, $depends_on_stock, $this->context->shop->id);
					}

					PrestaShopLogger::addLog(sprintf($this->l('%s edition', 'AdminTab', false, false), $this->className), 1, null, $this->className, (int)$this->object->id, true, (int)$this->context->employee->id);
					if (in_array($this->context->shop->getContext(), array(Shop::CONTEXT_SHOP, Shop::CONTEXT_ALL)))
					{
						if ($this->isTabSubmitted('Shipping'))
							$this->addCarriers();
						if ($this->isTabSubmitted('Associations'))
							$this->updateSimilars($object);
            if ($this->isTabSubmitted('Associations'))
							$this->updateSubstitutions($object);
						if ($this->isTabSubmitted('Associations'))
							$this->updateAccessories($object);
						if ($this->isTabSubmitted('Suppliers'))
							$this->processSuppliers();
						if ($this->isTabSubmitted('Features'))
							$this->processFeatures();
						if ($this->isTabSubmitted('Combinations'))
							$this->processProductAttribute();
						if ($this->isTabSubmitted('Prices'))
						{
							$this->processPriceAddition();
							$this->processSpecificPricePriorities();
						}
						if ($this->isTabSubmitted('Customization'))
							$this->processCustomizationConfiguration();
						if ($this->isTabSubmitted('Attachments'))
							$this->processAttachments();


						$this->updatePackItems($object);
						// Disallow avanced stock management if the product become a pack
						if ($product_type_before == Product::PTYPE_SIMPLE && $object->getType() == Product::PTYPE_PACK)
							StockAvailable::setProductDependsOnStock((int)$object->id, false);
						$this->updateDownloadProduct($object, 1);
						$this->updateTags(Language::getLanguages(false), $object);
						
						if ($this->isProductFieldUpdated('category_box') && !$object->updateCategories(Tools::getValue('categoryBox')))
							$this->errors[] = Tools::displayError('An error occurred while linking the object.').' <b>'.$this->table.'</b> '.Tools::displayError('To categories');
					}
					
					if ($this->isTabSubmitted('Warehouses'))
						$this->processWarehouses();
					if (empty($this->errors))
					{
						Hook::exec('actionProductUpdate', array('product' => $object));

						if (in_array($object->visibility, array('both', 'search')) && Configuration::get('PS_SEARCH_INDEXATION'))
							Search::indexation(false, $object->id);

						// Save and preview
						if (Tools::isSubmit('submitAddProductAndPreview'))
							$this->redirect_after = $this->getPreviewUrl($object);
						else
						{
							// Save and stay on same form
							if ($this->display == 'edit')
							{
								$this->confirmations[] = $this->l('Update successful');
								$this->redirect_after = self::$currentIndex.'&id_product='.(int)$this->object->id
									.(Tools::getIsset('id_category') ? '&id_category='.(int)Tools::getValue('id_category') : '')
									.'&updateproduct&conf=4&key_tab='.Tools::safeOutput(Tools::getValue('key_tab')).'&token='.$this->token;
							}
							else
								// Default behavior (save and back)
								$this->redirect_after = self::$currentIndex.(Tools::getIsset('id_category') ? '&id_category='.(int)Tools::getValue('id_category') : '').'&conf=4&token='.$this->token;
						}
					}
					// if errors : stay on edit page
					else
						$this->display = 'edit';
				}
				else
				{
					if (!$is_associated_to_shop && $combinations)
						foreach ($combinations as $id_combination)
						{
							$combination = new Combination((int)$id_combination['id_product_attribute']);
							$combination->delete();
						}
					$this->errors[] = Tools::displayError('An error occurred while updating an object.').' <b>'.$this->table.'</b> ('.Db::getInstance()->getMsgError().')';
				}
			}
			else
				$this->errors[] = Tools::displayError('An error occurred while updating an object.').' <b>'.$this->table.'</b> ('.Tools::displayError('The object cannot be loaded. ').')';
			return $object;
		}
	}

	/**
	 * Update product accessories
	 *
	 * @param object $product Product
	 */
	public function updateAccessories($product)
	{
		$product->deleteAccessories();
		if ($accessories = Tools::getValue('inputAccessories'))
		{
			$accessories_id = array_unique(explode('-', $accessories));
			if (count($accessories_id))
			{
				array_pop($accessories_id);
				$product->changeAccessories($accessories_id);
			}
		}
	}
  
  public function updateSimilars($product)
	{
		$product->deleteSimilars();
		if ($similars = Tools::getValue('inputSimilars'))
		{
			$similars_id = array_unique(explode('-', $similars));
			if (count($similars_id))
			{
				array_pop($similars_id);
				$product->changeSimilars($similars_id);
			}
		}
	}
  
  public function updateSubstitutions($product)
	{
		$product->deleteSubstitutions();
		if ($substitutions = Tools::getValue('inputSubstitutions'))
		{
			$substitutions_id = array_unique(explode('-', $substitutions));
			if (count($substitutions_id))
			{
				array_pop($substitutions_id);
				$product->changeSubstitutions($substitutions_id);
			}
		}
	}

	public function initFormAssociations($obj)
	{
		$product = $obj;
		$data = $this->createTemplate($this->tpl_form);
		// Prepare Categories tree for display in Associations tab
		$root = Category::getRootCategory();
		$default_category = $this->context->cookie->id_category_products_filter ? $this->context->cookie->id_category_products_filter : Context::getContext()->shop->id_category;
		if (!$product->id || !$product->isAssociatedToShop())
			$selected_cat = Category::getCategoryInformations(Tools::getValue('categoryBox', array($default_category)), $this->default_form_language);
		else
		{
			if (Tools::isSubmit('categoryBox'))
				$selected_cat = Category::getCategoryInformations(Tools::getValue('categoryBox', array($default_category)), $this->default_form_language);
			else
				$selected_cat = Product::getProductCategoriesFull($product->id, $this->default_form_language);
		}

		// Multishop block
		$data->assign('feature_shop_active', Shop::isFeatureActive());
		$helper = new HelperForm();
		if ($this->object && $this->object->id)
			$helper->id = $this->object->id;
		else
			$helper->id = null;
		$helper->table = $this->table;
		$helper->identifier = $this->identifier;

		// Accessories block
		$accessories = Product::getAccessoriesLight($this->context->language->id, $product->id);

		if ($post_accessories = Tools::getValue('inputAccessories'))
		{
			$post_accessories_tab = explode('-', Tools::getValue('inputAccessories'));
			foreach ($post_accessories_tab as $accessory_id)
				if (!$this->haveThisAccessory($accessory_id, $accessories) && $accessory = Product::getAccessoryById($accessory_id))
					$accessories[] = $accessory;
		}
		$data->assign('accessories', $accessories);
    // Substitutions block
		$substitutions = Product::getSubstitutionsLight($this->context->language->id, $product->id);

		if ($post_substitutions = Tools::getValue('inputSubstitutions'))
		{
			$post_substitutions_tab = explode('-', Tools::getValue('inputSubstitutions'));
			foreach ($post_substitutions_tab as $substitution_id)
				if (!$this->haveThisSubstitution($substitution_id, $substitutions) && $substitution = Product::getSubstitutionById($substitution_id))
					$substitutions[] = $substitution;
		}
		$data->assign('substitutions', $substitutions);
		// Similars block
		$similars = Product::getSimilarsLight($this->context->language->id, $product->id);

		if ($post_similars = Tools::getValue('inputSimilars'))
		{
			$post_similars_tab = explode('-', Tools::getValue('inputSimilars'));
			foreach ($post_similars_tab as $similar_id)
				if (!$this->haveThisSimilar($similar_id, $similars) && $similar = Product::getSimilarById($similar_id))
					$similars[] = $similar;
		}
		$data->assign('similars', $similars);

		$product->manufacturer_name = Manufacturer::getNameById($product->id_manufacturer);

		$categories = array();
		foreach ($selected_cat as $key => $category)
			$categories[] = $key;

		$tree = new HelperTreeCategories('associated-categories-tree', 'Associated categories');
		$tree->setTemplate('tree_associated_categories.tpl')
			->setHeaderTemplate('tree_associated_header.tpl')
			->setRootCategory($root->id)
			->setUseCheckBox(true)
			->setUseSearch(true)
			->setSelectedCategories($categories);

		$data->assign(array('default_category' => $default_category,
					'selected_cat_ids' => implode(',', array_keys($selected_cat)),
					'selected_cat' => $selected_cat,
					'id_category_default' => $product->getDefaultCategory(),
					'category_tree' => $tree->render(),
					'product' => $product,
					'link' => $this->context->link,
					'is_shop_context' => Shop::getContext() == Shop::CONTEXT_SHOP
		));

		$this->tpl_form_vars['custom_form'] = $data->fetch();
	}

	public function haveThisAccessory($accessory_id, $accessories)
	{
		foreach ($accessories as $accessory)
			if ((int)$accessory['id_product'] == (int)$accessory_id)
				return true;
		return false;
	}
	public function haveThisSimilar($similar_id, $similars)
	{
		foreach ($similars as $similar)
			if ((int)$similar['id_product'] == (int)$similar_id)
				return true;
		return false;
	}
  public function haveThisSubstitution($substitution_id, $substitutions)
	{
		foreach ($substitutions as $substitution)
			if ((int)$substitution['id_product'] == (int)$substitution_id)
				return true;
		return false;
	}

}

