<?php

require_once(_PS_TOOL_DIR_.'tcpdf/config/lang/eng.php');
require_once(_PS_TOOL_DIR_.'tcpdf/tcpdf.php');

/*
 * @author Comevents (Adrien)
 * Surcharge du controller de gestion des cheques cadeaux pour ajouter le cheque généré par mail
 */
class AdminCartRulesController  extends AdminCartRulesControllerCore
{
	public function __construct()
	{
		parent::__construct();
	}
  
	public function postProcess()
	{
    // Si on souhaite envoyer le mail alors on a clické sur le boutton ayant le nom submitAddcart_mail (voir form.tpl)
		if (Tools::isSubmit('submitAddcart_mail'))
		{
      // Debug
      /* 
      echo '<pre>';
      print_r($_POST);
      echo '</pre>';
      die('fin');
      */
            
      // ----------- Préparation du cheque cadeau
      global $cookie;
      $langue = (int)$cookie->id_lang;
      // Définition du destinataire
      $destinataire = 'web6@comevents.fr'; // destinataire par défaut
      if(isset($_POST[email_manucentre]) && strlen($_POST[email_manucentre])>0){
        $destinataire = $_POST[email_manucentre];
      }
      // Définition du type de réduction (montant ou pourcentage)
      $montant = '';
      switch ($_POST[apply_discount]) {
        case 'amount':
            $montant = $_POST[reduction_amount]. '€';
          break;
        case 'percent':
            $montant = $_POST[reduction_percent]. '%';
          break;
        default:
            $montant = 'Vous n\'avez pas appliqué de réduction';
          break;
      } 
      // Montant minimum
      $minimum_amount = (isset($_POST[minimum_amount]) && $_POST[minimum_amount]>0) ? "A partir de $_POST[minimum_amount] € d'achat." : '';
      
      // Code
      $code = isset($_POST[code])? "<br/>avec le code suivant: ".$_POST[code] : '';
      
      // Définition des produits/catégorie concerné par la réduction (facultatif)
      // Définition du produit cadeau (facultatif)
      
      
      // Construction du pdf
      $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
      $pdf->SetCreator(PDF_CREATOR);
      $pdf->SetAuthor('Manucentre');
      $pdf->SetTitle('Cheque cadeau');
      $pdf->SetSubject('Vous avez recu un cheque cadeau');
      $pdf->SetKeywords('Manucentre, cheque, reduction');
      $pdf->setPrintHeader(false);
      $pdf->setPrintFooter(false);
      $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
      $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
      $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
      $pdf->setImageScale(1.53);
      $pdf->AddPage();
      $html = $this->getTemplate($_POST, $montant, $minimum_amount, $code);
      $pdf->writeHTML($html, true, false, true, false, '');
      // Si il y a une erreur à ce niveaux, vérifier que les droits de ce fichier soit à 777
      $pdf->Output(dirname(__FILE__).'/mails/fr/cheque_cadeau.pdf', 'F');
      
      // Préparation de la pièce jointe
      $attach['content'] = file_get_contents(dirname(__FILE__).'/mails/fr/cheque_cadeau.pdf'); ; // url du pdf
      $attach['name'] = 'cheque_cadeau.pdf'; // Attachment filename
      $attach['mime'] = 'application/pdf'; // Mime file type
      
      // --------- Envoie du mail
      Mail::Send(
          $langue,                                                                      // langue
          'bonreduction',                                                               // nom du template (SANS L'EXTENSION)
          Mail::l('Vous avez reçu un chèque cadeau', $langue),                          // sujet
          array(
            '{name1}'               => $_POST[name_1],
            '{description}'         => isset($_POST[description])?$_POST[description]:'',
            '{code}'                => $code,
            '{date_from}'           => substr($_POST[date_from], 0, -9),
            '{date_to}'             => substr($_POST[date_to], 0, -9),
            '{minimum_amount}'      => $minimum_amount,
            '{quantity}'            => $_POST[quantity],
            '{free_shipping}'       => $_POST[free_shipping],
            '{montant}'             => $montant,
          ),                                                                            // paramètres à passer au template
          $destinataire,                                                                // destinataire du mail
          "Administrateur Manucentre",                                                  // nom du destinataire
          NULL,                                                                         // expéditeur 
          "Manucentre",                                                                 // expéditeur nom
          $attach,                                                                      // fichier joint
          NULL,                                                                         // Choix SMTP
          dirname(__FILE__).'/mails/'                                                   // répertoire des mails templates
      );
      // --------- Fin envoie du mail
      
		}
		return parent::postProcess();
	}
  
  function getTemplate($post, $montant, $minimum_amount, $code){
    $html =
      '
        <style>
          
          h1{color:#333;font-size: 22pt;text-align:center;}
          hr{height:5px;color:#555555;}
          .page{font-family:Helvetica;color:#333333;}
          .center{text-align:center;}
          .montant{font-size:3em;}
          .small{font-size:0.7em;}
          table{border:1px solid #555555;padding: 10px;background-color:#f8f8f8;color:#444444;}
        </style>
        
        <div class="page">   
          <div class="center">   
            <img src="http://shop.manucentre.fr/img/manucentre-1404199942.jpg"/>
          </div>
          
          <hr>
          
          <h1 class="center">Vous avez reçu un chèque cadeau !!</h1>
          
          <table bg-color>
            <tr>
              <th><p class="center">'.$post[name_1].'</p></th>
            </tr>
            <tr>
              <td>
                <div class="montant center">'.$montant.'</div>
                <h3 class="center">Valable sur tous le magasin'.$code.'</h3>
                <p>'.$post[description].'</p>
                <p>
                  <i>Offre valable du '.substr($post[date_from], 0, -9).' au '.substr($post[date_to], 0, -9).'.
                  '.$minimum_amount.'</i>
                </p>
              </td>
            </tr>
          </table>
          
          <h2>&nbsp;</h2>
          
          <p class="center small">
            CENTRALE MANUCENTRE<br/>
            Place Pierre Sémard<br/>
            15000 AURILLAC<br/>
            Numéro SIRET :<br/>
            789 754 249 00017
          </p>
        </div>
      ';
    
    return $html;
  }
  
  
}

