<?php
/*
 * @author Comevents (Adrien)
 * 
 * - peut exporter les produits     (@see postProcess 1ère condition)
 * - peut exporter les déclinaisons (@see postProcess 2ème condition)
 *    -> Remarque: une nouvelle déclinaison doit avoir une nouvelle référence sinon elle sera écraser
 * - peut importer les données de la colonne "En vente Flash (0/1)" (@see __construct)
 */
class AdminImportController extends AdminImportControllerCore
{
  
  /**
   * Insertion des ventes flash dans l'import de produit
   */
  public function __construct()
	{
    // On charge le contrusteur du parent
    parent::__construct();
    // PUIS on modifie les champs à charger pour les produits
    // Remarque: on est obligé de copier tout ce case du switch pour pouvoir insérer la colonne (sinon il faudrait la mettre à la fin)
		switch ((int)Tools::getValue('entity'))
		{
			case $this->entities[$this->l('Products')]:
				self::$validators['image'] = array(
					'AdminImportController',
					'split'
				);

				$this->available_fields = array(
					'no' => array('label' => $this->l('Ignore this column')),
					'id' => array('label' => $this->l('ID')),
					'active' => array('label' => $this->l('Active (0/1)')),
					'name' => array('label' => $this->l('Name')),
					'category' => array('label' => $this->l('Categories (x,y,z...)')),
					'price_tex' => array('label' => $this->l('Price tax excluded')),
					'price_tin' => array('label' => $this->l('Price tax included')),
					'id_tax_rules_group' => array('label' => $this->l('Tax rules ID')),
					'wholesale_price' => array('label' => $this->l('Wholesale price')),
					'on_sale' => array('label' => $this->l('On sale (0/1)')),
					'vente_flash' => array('label' => $this->l('En vente flash (0/1)')), // <-- C'est ici que l'on ajoute la colonne pour les ventes flash
					'reduction_price' => array('label' => $this->l('Discount amount')),
					'reduction_percent' => array('label' => $this->l('Discount percent')),
					'reduction_from' => array('label' => $this->l('Discount from (yyyy-mm-dd)')),
					'reduction_to' => array('label' => $this->l('Discount to (yyyy-mm-dd)')),
					'reference' => array('label' => $this->l('Reference #')),
					'supplier_reference' => array('label' => $this->l('Supplier reference #')),
					'supplier' => array('label' => $this->l('Supplier')),
					'manufacturer' => array('label' => $this->l('Manufacturer')),
					'ean13' => array('label' => $this->l('EAN13')),
					'upc' => array('label' => $this->l('UPC')),
					'ecotax' => array('label' => $this->l('Ecotax')),
					'width' => array('label' => $this->l('Width')),
					'height' => array('label' => $this->l('Height')),
					'depth' => array('label' => $this->l('Depth')),
					'weight' => array('label' => $this->l('Weight')),
					'quantity' => array('label' => $this->l('Quantity')),
					'minimal_quantity' => array('label' => $this->l('Minimal quantity')),
					'visibility' => array('label' => $this->l('Visibility')),
					'additional_shipping_cost' => array('label' => $this->l('Additional shipping cost')),
					'unity' => array('label' => $this->l('Unit for the unit price')),
					'unit_price' => array('label' => $this->l('Unit price')),
					'description_short' => array('label' => $this->l('Short description')),
					'description' => array('label' => $this->l('Description')),
					'tags' => array('label' => $this->l('Tags (x,y,z...)')),
					'meta_title' => array('label' => $this->l('Meta title')),
					'meta_keywords' => array('label' => $this->l('Meta keywords')),
					'meta_description' => array('label' => $this->l('Meta description')),
					'link_rewrite' => array('label' => $this->l('URL rewritten')),
					'available_now' => array('label' => $this->l('Text when in stock')),
					'available_later' => array('label' => $this->l('Text when backorder allowed')),
					'available_for_order' => array('label' => $this->l('Available for order (0 = No, 1 = Yes)')),
					'available_date' => array('label' => $this->l('Product available date')),
					'date_add' => array('label' => $this->l('Product creation date')),
					'show_price' => array('label' => $this->l('Show price (0 = No, 1 = Yes)')),
					'image' => array('label' => $this->l('Image URLs (x,y,z...)')),
					'delete_existing_images' => array(
						'label' => $this->l('Delete existing images (0 = No, 1 = Yes)')
					),
					'features' => array('label' => $this->l('Feature (Name:Value:Position:Customized)')),
					'online_only' => array('label' => $this->l('Available online only (0 = No, 1 = Yes)')),
					'condition' => array('label' => $this->l('Condition')),
					'customizable' => array('label' => $this->l('Customizable (0 = No, 1 = Yes)')),
					'uploadable_files' => array('label' => $this->l('Uploadable files (0 = No, 1 = Yes)')),
					'text_fields' => array('label' => $this->l('Text fields (0 = No, 1 = Yes)')),
					'out_of_stock' => array('label' => $this->l('Action when out of stock')),
					'shop' => array(
						'label' => $this->l('ID / Name of shop'),
						'help' => $this->l('Ignore this field if you don\'t use the Multistore tool. If you leave this field empty, the default shop will be used.'),
					),
					'advanced_stock_management' => array(
						'label' => $this->l('Advanced Stock Management'),
						'help' => $this->l('Enable Advanced Stock Management on product (0 = No, 1 = Yes).')
					),
					'depends_on_stock' => array(
						'label' => $this->l('Depends on stock'),
						'help' => $this->l('0 = Use quantity set in product, 1 = Use quantity from warehouse.')
					),
					'warehouse' => array(
						'label' => $this->l('Warehouse'),
						'help' => $this->l('ID of the warehouse to set as storage.')
					),
				);
		}
		
	}
  
  /*
   * Ajout de l'export dans cette fonction
   * 
   * méthode:
   *  1- Récupération des produits
   *  2- Définition de la marge (header)
   *  3- Ajout du contenu:
   *    a. Récupération des cellules à plusieurs valeurs (comme les catégories, mots clés...)
   *    b. Récupération des valeurs dans une boucle
   *    c. Remise en ordre des valeurs dans l'ordre des colonnes du csv
   */
  public function postProcess()
	{
    // Si l'utilisateur veut un import ou un export alors il a posté un formulaire
    if($_POST){
      // =====================================================================
      //                     EXPORT DE PRODUIT
      // =====================================================================
      if(isset($_POST[csv_export]) && $_POST[csv_export] == 'export'){
        // 1- Récupération des produits
        $select = "SELECT p.*";
        $jointure = " FROM "._DB_PREFIX_."product p";
        $select .= ", pl.* ";
        $jointure .= " JOIN "._DB_PREFIX_."product_lang pl ON pl.id_product = p.id_product";
        $select .= ", stock.quantity as stock ";
        $jointure .= " JOIN "._DB_PREFIX_."stock_available stock ON stock.id_product = p.id_product";
        /*$select .= ", CASE 
                      WHEN p.id_tax_rules_group=1 THEN p.price*1.20
                      WHEN p.id_tax_rules_group=2 THEN p.price*1.10
                      WHEN p.id_tax_rules_group=3 THEN p.price*1.055
                      WHEN p.id_tax_rules_group=4 THEN p.price*1.021
                      ELSE 'Prix inférieur à la normale'
                    END AS prixTTC";*/
        // Le group by permet de ne lire que le produit principal en cas de déclinaison.
        // Remarque: la quantité est automatiquement la somme des quantités dans les déclinaisons
        $groupby = " GROUP BY p.id_product"; 
        
        $sql = $select.$jointure.$groupby;
        $res = Db::getInstance()->executeS($sql);
        
        // echo '<pre>'; print_r($res); echo '</pre>'; die(); // DEBUG
        
        // clean buffer
        if (ob_get_level() && ob_get_length() > 0)
          ob_clean();

        header('Content-type: text/csv');
        header('Content-Type: application/force-download; charset=UTF-8');
        header('Cache-Control: no-store, no-cache');
        header('Content-disposition: attachment; filename="export_produits_'.date('Y-m-d_His').'.csv"');

        // 2- Définition de la marge (header)
        $headers = array(
          'ID', 
          "Actif(0/1)", 
          "Nom", 
          "Catégories (x,y,z...)",
          "Prix HT OU Prix TTC", 
          "ID règles de taxes", 
          "Prix d'achat", 
          "En soldes (0/1)", 
          "En vente flash (0/1)",
          "Montant de la remise", 
          "Pourcentage de réduction", 
          "Réduction de (aaaa-mm-jj)", 
          "Réduction à (aaaa-mm-jj)", 
          "Référence", 
          "Référence fournisseur", 
          "Fournisseurs", 
          "Fabricant", 
          "EAN-13", 
          "UPC", 
          "Écotaxe", 
          "Largeur", 
          "Hauteur", 
          "Profondeur", 
          "Poids", 
          "Quantité", 
          "Quantité minimale", 
          "Visibilité", 
          "Frais de port supplémentaire", 
          "Unité pour le prix unitaire", 
          "Prix unitaire", 
          "Résumé", 
          "Description", 
          "Mot-clés (x,y,z...)", 
          "Balise titre", 
          "Meta mots-clés", 
          "Meta Description", 
          "URL simplifiée", 
          'Texte "En stock"', 
          'Texte "En précommande" (si activé)', 
          "Disponible à la commande (0 = Non, 1 = Oui)", 
          "Date de disponibilité du produit", 
          "Date d'ajout du produit", 
          "Afficher le prix (0 = Non, 1 = Oui)", 
          "URL des images (x,y,z, etc.)", 
          "Supprimer les images existantes (0 = Non, 1 = Oui)", 
          "Caractéristique (Nom:Valeur:Position:Personnalisé)", 
          "Disponible en ligne uniquement (0 = Non, 1 = Oui)", 
          "État", 
          "Personnalisable (0 = Non, 1 = Oui)", 
          "Fichiers téléchargeables (0 = Non, 1 = Oui)", 
          "Champs texte (0 = Non, 1 = Oui)", 
          //"Action en cas de rupture de stock", 
        );
        
        // 3- Ajout du contenu:
        $content = array();
        $contenu_dans_bon_ordre = array();
        // Pour chaque produit
        foreach ($res as $i => $row)
        {   
          // 3a. Récupération des cellules à plusieurs valeurs (comme les catégories, mots clés...)
            //  DEBUT Ajout des categories 
            $sql = "
              SELECT cl.name FROM "._DB_PREFIX_."category_product cp 
              INNER JOIN "._DB_PREFIX_."category c ON cp.id_category=c.id_category 
              INNER JOIN "._DB_PREFIX_."category_lang cl ON cl.id_category=c.id_category 
              WHERE cp.id_product = ".$row['id_product'];
            $res = Db::getInstance()->executeS($sql);

            $j=0;
            $categories = '';
            foreach($res as $categorie){
              if($j>0) $categories .= ', ';
              $categories .= $categorie['name'];
              $j++;
            }
            //  FIN ajout des catégories 
            
            //  DEBUT Recherche d'une eventuelle promotion 
            $sql = "
              SELECT sp.* FROM "._DB_PREFIX_."specific_price sp
              WHERE sp.id_product = ".$row['id_product'];
            $promotion = Db::getInstance()->executeS($sql);
            $montant_de_la_remise = null;
            $pourcentage_de_la_reduction = null;
            $reduction_de = null;
            $reduction_a = null;
            if(isset($promotion) && count($promotion)>0){
              if($promotion[0]['reduction_type']=='amount'){
                $montant_de_la_remise = $promotion[0]['reduction'];
              }
              if($promotion[0]['reduction_type']=='percentage'){
                $pourcentage_de_la_reduction = $promotion[0]['reduction'] * 100;
              }
              $reduction_de = substr($promotion[0]['from'], 0, 10);
              $reduction_a = substr($promotion[0]['to'], 0, 10);
            }            
            //  FIN Recherche d'une eventuelle promotion 
            
            //  DEBUT Recherche des fournisseurs 
            $sql = "
              SELECT fournisseur.name FROM "._DB_PREFIX_."product_supplier pr_fournisseur 
              INNER JOIN "._DB_PREFIX_."supplier fournisseur ON pr_fournisseur.id_supplier=fournisseur.id_supplier 
              WHERE pr_fournisseur.id_product = ".$row['id_product'];
            $res = Db::getInstance()->executeS($sql);

            $k=0;
            $fournisseurs = '';
            foreach($res as $fournisseur){
              if($k>0) $fournisseurs .= ', ';
              $fournisseurs .= $fournisseur['name'];
              $k++;
            }
            //  FIN Recherche des fournisseurs 
            
            //  DEBUT Recherche du fabriquant 
            $sql = "
              SELECT fabriquant.name as nom_fabriquant FROM "._DB_PREFIX_."manufacturer fabriquant
              WHERE fabriquant.id_manufacturer = ".$row['id_manufacturer'];
            $res = Db::getInstance()->executeS($sql);
            $fabriquant = $res[0]['nom_fabriquant'];
            //  FIN Recherche du fabriquant 
            
            //  DEBUT Recherche des mots clés (tags) 
            $sql = "
              SELECT tag.name FROM "._DB_PREFIX_."product_tag ptag 
              INNER JOIN "._DB_PREFIX_."tag tag ON tag.id_tag = ptag.id_tag 
              WHERE ptag.id_product = ".$row['id_product'];
            $res = Db::getInstance()->executeS($sql);

            $l=0;
            $tags = '';
            foreach($res as $tag){
              if($l>0) $tags .= ', ';
              $tags .= $tag['name'];
              $l++;
            }
            //  FIN Recherche des mots clés 
            
            //  DEBUT Recherche de l'url de l'image -> Annulé il est préférable de ne pas les récupérer pour éviter de les écraser
            /*  // Explication du format de l'url
              // adresse_site/dossier_img/p/premier_chiffre_id_image/deuxieme_chiffre_id_image/id_image.jpg
            
              // 1. On récupère tous les identifiants des images lié à ce produit
              $sql = "
              SELECT img.id_image  FROM "._DB_PREFIX_."image img
              WHERE img.id_product = ".$row['id_product'];
              $res = Db::getInstance()->executeS($sql);
              
              
              // 2. On récupère ainsi les urls de chaque image
              $m=0;
              $images_url = '';
              foreach($res as $id_image){
                $image = new Image($id_image['id_image']);
                if($m>0) $images_url .= ', ';
                $images_url .= _PS_BASE_URL_._THEME_PROD_DIR_.$image->getImgPath().".jpg";
                $m++;
              }
            */
            //  FIN Recherche de l'image 
            
            //  DEBUT Recherche des caractéristiques 
            // 1. On récupère toutes les caractéristiques liées à ce produit
            $sql = "
              SELECT fl.name, fvl.value FROM "._DB_PREFIX_."feature_product fp
              INNER JOIN ps_feature_lang AS fl ON fl.id_feature = fp.id_feature
              INNER JOIN ps_feature_value_lang AS fvl ON fvl.id_feature_value = fp.id_feature_value
              WHERE fp.id_product = ".$row['id_product'];
            
            $results = Db::getInstance()->executeS($sql);
            
            // 2. On récupère ainsi les caractéristiques de chaque produit
            $n=0;
            $caracteristiques = '';
            foreach($results as $caracteristique){
              if($n>0) $caracteristiques .= ', ';
              $caracteristiques .= $caracteristique[name].':'.$caracteristique[value];
              $n++;
            }
            //  FIN Recherche des caractéristiques 
          
            $unit_price_ratio = 0; // Permet de calculer le prix unitaire
          // 3b. Récupération des valeurs dans une boucle
          foreach($row as $key => $value){
            switch ($key) {
                case 'id_product':
                    $content[$i]['ID'] = $value;
                    break;
                case 'active':
                    $content[$i]['Actif(0/1)'] = $value;
                    break;
                case 'name':
                    $content[$i]['Nom'] = $value;
                    break;
                case 'price':
                    $content[$i]['Prix HT OU Prix TTC'] = $value;
                    break;
                case 'id_tax_rules_group':
                    $content[$i]['ID règles de taxes'] = $value;
                    break;
                case 'wholesale_price':
                    $content[$i]["Prix d'achat"] = $value;
                    break;
                case 'on_sale':
                    $content[$i]['En soldes (0/1)'] = $value;
                    break;
                case 'vente_flash':
                    $content[$i]['En vente flash (0/1)'] = $value;
                    break;
                case 'reference':
                    $content[$i]['Référence'] = $value;
                    break;
                case 'supplier_reference':
                    $content[$i]['Référence fournisseur'] = $value;
                    break;
                case 'ean13':
                    $content[$i]['EAN-13'] = $value;
                    break;
                case 'upc':
                    $content[$i]['UPC'] = $value;
                    break;
                case 'ecotax':
                    $content[$i]['Écotaxe'] = $value;
                    break;
                case 'width':
                    $content[$i]['Largeur'] = $value;
                    break;
                case 'height':
                    $content[$i]['Hauteur'] = $value;
                    break;
                case 'depth':
                    $content[$i]['Profondeur'] = $value;
                    break;
                case 'weight':
                    $content[$i]['Poids'] = $value;
                    break;
                case 'stock':
                    $content[$i]['Quantité'] = $value;
                    break;
                case 'minimal_quantity':
                    $content[$i]['Quantité minimale'] = $value;
                    break;
                case 'visibility':
                    $content[$i]['Visibilité'] = $value;
                    break;
                case 'additional_shipping_cost':
                    $content[$i]['Frais de port supplémentaire'] = $value;
                    break;
                case 'unity':
                    $content[$i]['Unité pour le prix unitaire'] = $value;
                    break;
                case 'unit_price_ratio':
                    $unit_price_ratio = $value;
                    break;
                case 'description_short':
                    $content[$i]['Résumé'] = $value;
                    break;
                case 'description':
                    $content[$i]['Description'] = $value;
                    break;
                case 'meta_title':
                    $content[$i]['Balise titre'] = $value;
                    break;
                case 'meta_keywords':
                    $content[$i]['Meta mots-clés'] = $value;
                    break;
                case 'meta_description':
                    $content[$i]['Meta Description'] = $value;
                    break;
                case 'link_rewrite':
                    $content[$i]['URL simplifiée'] = $value;
                    break;
                /*case 'todo':
                    $content[$i]['Texte "En stock"'] = $value;
                    break;
                case 'todo':
                    $content[$i]['Texte "En précommande" (si activé)'] = $value;
                    break;*/
                case 'available_for_order':
                    $content[$i]['Disponible à la commande (0 = Non, 1 = Oui)'] = $value;
                    break;
                case 'available_date':
                    $content[$i]['Date de disponibilité du produit'] = $value;
                    break;
                case 'date_add':
                    $content[$i]["Date d'ajout du produit"] = substr($value,0,10);
                    break;
                case 'show_price':
                    $content[$i]['Afficher le prix (0 = Non, 1 = Oui)'] = $value;
                    break;
                case 'online_only':
                    $content[$i]['Disponible en ligne uniquement (0 = Non, 1 = Oui)'] = $value;
                    break;
                case 'condition':
                    $content[$i]['État'] = $value;
                    break;
                case 'customizable':
                    $content[$i]['Personnalisable (0 = Non, 1 = Oui)'] = $value;
                    break;
                case 'uploadable_files':
                    $content[$i]['Fichiers téléchargeables (0 = Non, 1 = Oui)'] = $value;
                    break;
                case 'text_fields':
                    $content[$i]['Champs texte (0 = Non, 1 = Oui)'] = $value;
                    break;
            }
          }
          
          // 3c. Remise en ordre des valeurs dans l'ordre des colonnes du csv
          $contenu_dans_bon_ordre[$i]['ID'] = $content[$i]['ID'];
          $contenu_dans_bon_ordre[$i]['Actif(0/1)'] = $content[$i]['Actif(0/1)'];
          $contenu_dans_bon_ordre[$i]['Nom'] = $content[$i]['Nom'];
          $contenu_dans_bon_ordre[$i]['Catégories (x,y,z...)'] = $categories;
          $contenu_dans_bon_ordre[$i]['Prix HT OU Prix TTC'] = $content[$i]['Prix HT OU Prix TTC'];
          $contenu_dans_bon_ordre[$i]['ID règles de taxes'] = $content[$i]['ID règles de taxes'];
          $contenu_dans_bon_ordre[$i]["Prix d'achat"] = $content[$i]["Prix d'achat"];
          $contenu_dans_bon_ordre[$i]['En soldes (0/1)'] = $content[$i]['En soldes (0/1)'];
          $contenu_dans_bon_ordre[$i]['En vente flash (0/1)'] = $content[$i]['En vente flash (0/1)'];
          $contenu_dans_bon_ordre[$i]['Montant de la remise'] = $montant_de_la_remise;
          $contenu_dans_bon_ordre[$i]['Pourcentage de réduction'] = $pourcentage_de_la_reduction;
          $contenu_dans_bon_ordre[$i]['Réduction de (aaaa-mm-jj)'] = $reduction_de;
          $contenu_dans_bon_ordre[$i]['Réduction à (aaaa-mm-jj)'] = $reduction_a;
          $contenu_dans_bon_ordre[$i]['Référence'] = $content[$i]['Référence'];
          $contenu_dans_bon_ordre[$i]['Référence fournisseur'] = $content[$i]['Référence fournisseur'];
          $contenu_dans_bon_ordre[$i]['Fournisseurs'] = $fournisseurs;
          $contenu_dans_bon_ordre[$i]['Fabricant'] = $fabriquant;
          $contenu_dans_bon_ordre[$i]['EAN-13'] = $content[$i]['EAN-13'];
          $contenu_dans_bon_ordre[$i]['UPC'] = $content[$i]['UPC'];
          $contenu_dans_bon_ordre[$i]['Écotaxe'] = $content[$i]['Écotaxe'];
          $contenu_dans_bon_ordre[$i]['Largeur'] = $content[$i]['Largeur'];
          $contenu_dans_bon_ordre[$i]['Hauteur'] = $content[$i]['Hauteur'];
          $contenu_dans_bon_ordre[$i]['Profondeur'] = $content[$i]['Profondeur'];
          $contenu_dans_bon_ordre[$i]['Poids'] = $content[$i]['Poids'];
          $contenu_dans_bon_ordre[$i]['Quantité'] = $content[$i]['Quantité'];
          $contenu_dans_bon_ordre[$i]['Quantité minimale'] = $content[$i]['Quantité minimale'];
          $contenu_dans_bon_ordre[$i]['Visibilité'] = $content[$i]['Visibilité'];
          $contenu_dans_bon_ordre[$i]['Frais de port supplémentaire'] = $content[$i]['Frais de port supplémentaire'];
          $contenu_dans_bon_ordre[$i]['Unité pour le prix unitaire'] = $content[$i]['Unité pour le prix unitaire'];
          $contenu_dans_bon_ordre[$i]['Prix unitaire'] = $content[$i]['Prix HT OU Prix TTC']/$unit_price_ratio;
          $contenu_dans_bon_ordre[$i]['Résumé'] = $content[$i]['Résumé'];
          $contenu_dans_bon_ordre[$i]['Description'] = $content[$i]['Description'];
          $contenu_dans_bon_ordre[$i]['Mot-clés (x,y,z...)'] = $tags;
          $contenu_dans_bon_ordre[$i]['Balise titre'] = $content[$i]['Balise titre'];
          $contenu_dans_bon_ordre[$i]['Meta mots-clés'] = $content[$i]['Meta mots-clés'];
          $contenu_dans_bon_ordre[$i]['Meta Description'] = $content[$i]['Meta Description'];
          $contenu_dans_bon_ordre[$i]['URL simplifiée'] = $content[$i]['URL simplifiée'];
          $contenu_dans_bon_ordre[$i]['Texte En stock""'] = null; //todo
          $contenu_dans_bon_ordre[$i]['Texte En précommande" (si activé)"'] = null; //todo
          $contenu_dans_bon_ordre[$i]['Disponible à la commande (0 = Non, 1 = Oui)'] = $content[$i]['Disponible à la commande (0 = Non, 1 = Oui)'];
          $contenu_dans_bon_ordre[$i]['Date de disponibilité du produit'] = $content[$i]['Date de disponibilité du produit'];
          $contenu_dans_bon_ordre[$i]["Date d'ajout du produit"] = $content[$i]["Date d'ajout du produit"];
          $contenu_dans_bon_ordre[$i]['Afficher le prix (0 = Non, 1 = Oui)'] = $content[$i]['Afficher le prix (0 = Non, 1 = Oui)'];
          $contenu_dans_bon_ordre[$i]['URL des images (x,y,z, etc.)'] = null; //$images_url;
          $contenu_dans_bon_ordre[$i]['Supprimer les images existantes (0 = Non, 1 = Oui)'] = 0; //todo
          $contenu_dans_bon_ordre[$i]['Caractéristique (Nom:Valeur:Position:Personnalisé)'] = $caracteristiques;
          $contenu_dans_bon_ordre[$i]['Disponible en ligne uniquement (0 = Non, 1 = Oui)'] = $content[$i]['Disponible en ligne uniquement (0 = Non, 1 = Oui)'];
          $contenu_dans_bon_ordre[$i]['État'] = $content[$i]['État'];
          $contenu_dans_bon_ordre[$i]['Personnalisable (0 = Non, 1 = Oui)'] = $content[$i]['Personnalisable (0 = Non, 1 = Oui)'];
          $contenu_dans_bon_ordre[$i]['Fichiers téléchargeables (0 = Non, 1 = Oui)'] = $content[$i]['Fichiers téléchargeables (0 = Non, 1 = Oui)'];
          $contenu_dans_bon_ordre[$i]['Champs texte (0 = Non, 1 = Oui)'] = $content[$i]['Champs texte (0 = Non, 1 = Oui)'];
        }

        $this->context->smarty->assign(array(
          'export_precontent' => "\xEF\xBB\xBF",
          'export_headers' => $headers,
          'export_content' => $contenu_dans_bon_ordre,
          'text_delimiter' => '"'
          )
        );

        $this->layout = 'layout-export.tpl';
      }
      
      
      //============================================================================================
      //                    EXPORT DE DECLINAISONS
      //============================================================================================
      // Si c'est un export de déclinaisons
      if(isset($_POST[csv_export_declinaison]) && $_POST[csv_export_declinaison] == 'export_declinaison'){
        // 1- Récupération des produits
        $select = "SELECT *";
        $jointure .= "FROM "._DB_PREFIX_."product_attribute";
        
        $sql = $select.$jointure;
        $res = Db::getInstance()->executeS($sql);
        
        // clean buffer
        if (ob_get_level() && ob_get_length() > 0)
          ob_clean();

        header('Content-type: text/csv');
        header('Content-Type: application/force-download; charset=UTF-8');
        header('Cache-Control: no-store, no-cache');
        header('Content-disposition: attachment; filename="export_declinaison_'.date('Y-m-d_His').'.csv"');

        // 2- Définition de la marge (header)
        $headers = array(
          'ID produit*', 
          'Attribut (Nom:Type:Position)*', 
          'Valeur (Valeur:Position)*', 
          'Référence fournisseur', 
          'Référence', 
          'EAN-13', 
          'UPC', 
          "Prix d'achat", 
          'Impact sur le prix', 
          'Écotaxe', 
          'Quantité', 
          'Quantité minimale', 
          'Impact sur le poids', 
          'Valeurs par défaut (0 = Non, 1 = Oui)', 
          "Position de l'image", 
          "URL de l'image", 
          'Supprimer les images existantes (0 = Non, 1 = Oui)', 
        );

        // 3- Ajout du contenu:
        $content = array();
        $contenu_dans_bon_ordre = array();
        
        // Pour chaque produit
        foreach ($res as $i => $row)
        {   
          // -- DEBUT Recherche des attributs et de leurs valeurs
            // 1. On récupère tous les attributs liées à cette déclinaison
            $sql = "
              SELECT pac.id_attribute, agl.name AS group_name, ag.group_type, ag.position, al.name AS valeur
              FROM "._DB_PREFIX_."product_attribute_combination pac
              JOIN "._DB_PREFIX_."attribute a ON a.id_attribute = pac.id_attribute
              JOIN "._DB_PREFIX_."attribute_lang al ON al.id_attribute = pac.id_attribute
              JOIN "._DB_PREFIX_."attribute_group ag ON ag.id_attribute_group = a.id_attribute_group
              JOIN "._DB_PREFIX_."attribute_group_lang agl ON agl.id_attribute_group = a.id_attribute_group
              WHERE pac.id_product_attribute = ".$row['id_product_attribute'];

            $results = Db::getInstance()->executeS($sql);

            // 2. On récupère ainsi les attributs de chaque produit
            $z=0;
            $attributs = '';
            $valeurs = '';
            foreach($results as $attribut){
              if($z>0) {
                $attributs .= ', ';
                $valeurs .= ', ';
              }
              $attributs .= $attribut[group_name].':'.$attribut[group_type]; //.':'.$attribut[position];
              $valeurs .= $attribut[valeur]; //.':'.$attribut[position];
              $z++;
            }
          // -- FIN Recherche des attributs et de leurs valeurs
          
          // 3b. Récupération des valeurs dans une boucle
          foreach($row as $key => $value){
            switch ($key) {
                case 'id_product':
                    $content[$i]['ID produit*'] = $value;
                    break;
                case 'supplier_reference':
                    $content[$i]['Référence fournisseur'] = $value;
                    break;
                case 'reference':
                    $content[$i]['Référence'] = $value;
                    break;
                case 'ean13':
                    $content[$i]['EAN-13'] = $value;
                    break;
                case 'upc':
                    $content[$i]['UPC'] = $value;
                    break;
                case 'wholesale_price':
                    $content[$i]["Prix d'achat"] = $value;
                    break;
                case 'unit_price_impact':
                    $content[$i]['Impact sur le prix'] = $value;
                    break;
                case 'weight':
                    $content[$i]['Impact sur le poids'] = $value;
                    break;
                case 'ecotax':
                    $content[$i]['Écotaxe'] = $value;
                    break;
                case 'quantity':
                    $content[$i]['Quantité'] = $value;
                    break;
                case 'minimal_quantity':
                    $content[$i]['Quantité minimale'] = $value;
                    break;
                case 'default_on':
                    $content[$i]['Valeurs par défaut (0 = Non, 1 = Oui)'] = $value;
                    break;
            }
          }
          
          // 3c. Remise en ordre des valeurs dans l'ordre des colonnes du csv
          $contenu_dans_bon_ordre[$i]["ID produit*"] = $content[$i]["ID produit*"];
          $contenu_dans_bon_ordre[$i]["Attribut (Nom:Type:Position)*"] = $attributs;
          $contenu_dans_bon_ordre[$i]["Valeur (Valeur:Position)*"] = $valeurs;
          $contenu_dans_bon_ordre[$i]["Référence fournisseur"] = $content[$i]["Référence fournisseur"];
          $contenu_dans_bon_ordre[$i]["Référence"] = $content[$i]["Référence"];
          $contenu_dans_bon_ordre[$i]["EAN-13"] = $content[$i]["EAN-13"];
          $contenu_dans_bon_ordre[$i]["UPC"] = $content[$i]["UPC"];
          $contenu_dans_bon_ordre[$i]["Prix d'achat"] = $content[$i]["Prix d'achat"];
          $contenu_dans_bon_ordre[$i]["Impact sur le prix"] = $content[$i]["Impact sur le prix"];
          $contenu_dans_bon_ordre[$i]["Écotaxe"] = $content[$i]["Écotaxe"];
          $contenu_dans_bon_ordre[$i]["Quantité"] = $content[$i]["Quantité"];
          $contenu_dans_bon_ordre[$i]["Quantité minimale"] = $content[$i]["Quantité minimale"];
          $contenu_dans_bon_ordre[$i]["Impact sur le poids"] = $content[$i]['Impact sur le poids'];
          $contenu_dans_bon_ordre[$i]["Valeurs par défaut (0 = Non, 1 = Oui)"] = $content[$i]["Valeurs par défaut (0 = Non, 1 = Oui)"];
          $contenu_dans_bon_ordre[$i]["Position de l'image"] = null; //$content[$i]["Position de l'image"];
          $contenu_dans_bon_ordre[$i]["URL de l'image"] = null; // Par défaut on ne supprime pas les images des déclinaisons
          $contenu_dans_bon_ordre[$i]["Supprimer les images existantes (0 = Non, 1 = Oui)"] = 0; // Par défaut on ne supprime pas les images des déclinaisons
        }

        $this->context->smarty->assign(array(
          'export_precontent' => "\xEF\xBB\xBF",
          'export_headers' => $headers,
          'export_content' => $contenu_dans_bon_ordre,
          'text_delimiter' => '"'
          )
        );

        $this->layout = 'layout-export.tpl';
      }
      
    }
    
    return parent::postProcess();
  }
  
  
}

