{*
*  @author Comevents (Adrien)
*  a été surchargé pour afficher un message d'information ("Laissez les champs "Balise titre" et...")
*}
<div id="product-seo" class="panel product-tab">
	<input type="hidden" name="submitted_tabs[]" value="Seo" />
	<h3>{l s='SEO'}</h3>

    <!-- DEBUT partie surchargée (voir class override/classes/Meta.php pour automatiser les metas)-->
	{include file="controllers/products/multishop/check_fields.tpl" product_tab="Seo"}
    <div class="alert alert-info">
        <ul>Laissez les champs "Balise titre" et "Meta Description" vide pour gérer ces champs automatiquement.
            <li>Format de la balise titre: <i>"Categorie principale"</i> - <i>"nom du produit"</i> de <i>"marque du produit"</i></li>
            <li>Format de la meta description: <i>"description courte du produit" </i> (limité à 160 caractères)</li>
        </ul>
	</div>
    <!-- FIN partie surchargée -->

	<div class="form-group">
		<label class="control-label col-lg-3" for="meta_title_{$id_lang}">
			{include file="controllers/products/multishop/checkbox.tpl" field="meta_title" type="default" multilang="true"}
			<span class="label-tooltip" data-toggle="tooltip"
				title="{l s='Public title for the product\'s page, and for search engines. Leave blank to use the product name.'}">
				{l s='Meta title'}
			</span>
		</label>
		<div class="col-lg-8">
			{include file="controllers/products/input_text_lang.tpl"
				languages=$languages
				input_name='meta_title'
				input_value=$product->meta_title
				maxchar=70
			}
		</div>
	</div>

	<div class="form-group">		
		<label class="control-label col-lg-3" for="meta_description_{$id_lang}">
			{include file="controllers/products/multishop/checkbox.tpl" field="meta_description" type="default" multilang="true"}
			<span class="label-tooltip" data-toggle="tooltip"
				title="{l s='This description will appear in search engines. You need a single sentence, shorter than 160 characters (including spaces).'}">
				{l s='Meta description'}
			</span>
		</label>
		<div class="col-lg-8">
			{include file="controllers/products/input_text_lang.tpl"
				languages=$languages
				input_name='meta_description'
				input_value=$product->meta_description
				maxchar=160
			}
		</div>
	</div>
	{* Removed for simplicity *}
	<div class="form-group hide">
		<label class="control-label col-lg-3" for="meta_keywords_{$id_lang}">
			{include file="controllers/products/multishop/checkbox.tpl" field="meta_keywords" type="default" multilang="true"}
			<span class="label-tooltip" data-toggle="tooltip"
				title="{l s='Keywords for search engines, separated by commas.'}">
				{l s='Meta keywords'}
			</span>
		</label>
		<div class="col-lg-8">
			{include file="controllers/products/input_text_lang.tpl" languages=$languages
				input_value=$product->meta_keywords
				input_name='meta_keywords'}
		</div>
	</div>

	<div class="form-group">
		<label class="control-label col-lg-3" for="link_rewrite_{$id_lang}">
			{include file="controllers/products/multishop/checkbox.tpl" field="link_rewrite" type="seo_friendly_url" multilang="true"}
			<span class="label-tooltip" data-toggle="tooltip"
				title="{l s='This is the human-readable URL, as generated from the product\'s name. You can change it if you want.'}">
				{l s='Friendly URL:'}
			</span>

		</label>
		<div class="col-lg-6">
				{include file="controllers/products/input_text_lang.tpl"
					languages=$languages
					input_value=$product->link_rewrite
					input_name='link_rewrite'}
		</div>
		<div class="col-lg-2">
			<button type="button" class="btn btn-default" id="generate-friendly-url" onmousedown="updateFriendlyURLByName();"><i class="icon-random"></i> {l s='Generate'}</button>
		</div>
	</div>

	<div class="row">
		<div class="col-lg-9 col-lg-offset-3">
			{foreach from=$languages item=language}
			<div class="alert alert-warning translatable-field lang-{$language.id_lang}">
				<i class="icon-link"></i> {l s='The product link will look like this:'}<br/>
				<strong>{$curent_shop_url|escape:'html':'UTF-8'}lang/{if isset($product->id)}{$product->id}{else}id_product{/if}-<span id="friendly-url_{$language.id_lang}">{$product->link_rewrite[$default_language]|escape:'html':'UTF-8'}</span>.html</strong>
			</div>
			{/foreach}
		</div>
	</div>
	<div class="panel-footer">
		<a href="{$link->getAdminLink('AdminProducts')}" class="btn btn-default"><i class="process-icon-cancel"></i> {l s='Cancel'}</a>
		<button type="submit" name="submitAddproduct" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save'}</button>
		<button type="submit" name="submitAddproductAndStay" class="btn btn-default pull-right"><i class="process-icon-save"></i> {l s='Save and stay'}</button>
	</div>
</div>
<script type="text/javascript">
	hideOtherLanguage({$default_form_language});
</script>
